#include <string>
#include <vector>
#include <bits/stdc++.h>

#define forn(i, n) for(int i = 0; i < (int)(n); ++i)
#define for1(i, n) for(int i = 1; i <= (int)(n); ++i)
#define fore(i, a, b) for(int i = (int)(a); i <= (int)(b); ++i)
#define ford(i, n) for(int i = (int)(n) - 1; i >= 0; --i)
#define all(v) (v).begin(), (v).end()
#define mp make_pair
#define pb push_back
#define fi first
#define se second

using namespace std;

typedef vector<int> vi;
typedef vector<vi> vvi;
typedef pair<int, int> pii;
typedef vector<pii> vpi;
typedef long long i64;
typedef unsigned long long u64;
typedef long double ld;

struct TEdge
{
    int to, w, num;
    TEdge(int to, int w, int num): to(to), w(w), num(num) {}
    TEdge() {}
};

typedef vector<TEdge> ve;
typedef vector<ve> vve;

const int N = 100500, inf = 2e9 + 10;
int timer = 0;
vector<char> used;
int tin[N], fup[N];
vi ans;

vi dijkstra(const vve& g, int st)
{
    vi d(g.size(), inf);
    d[st] = 0;
    set<pii> S;
    S.insert(mp(d[st], st));
    while (!S.empty())
    {
        int v = S.begin()->se;
        S.erase(S.begin());
        for (auto w: g[v])
            if (d[w.to] > d[v] + w.w)
            {
                S.erase(mp(d[w.to], w.to));
                d[w.to] = d[v] + w.w;
                S.insert(mp(d[w.to], w.to));
            }
    }
    return d;
}

map<pair<pii, int>, int> Q;

void dfs(const vve& g, int v, int p = -1)
{
    used[v] = 1;
    tin[v] = fup[v] = timer++;
    for (auto w: g[v])
    {
        if (w.to == p) continue;
        if (used[w.to])
            fup[v] = min(fup[v], tin[w.to]);
        else
        {
            dfs(g, w.to, v);
            fup[v] = min(fup[v], fup[w.to]);
            if (fup[w.to] > tin[v])
            {
                if (Q[mp(mp(v, w.to), w.w)] == 1)
                    ans.pb(w.num);
            }
        }
    }
}

int main()
{
#ifdef HOME
    freopen("input.txt", "r", stdin);
#endif
    int n, m;
    scanf("%d%d", &n, &m);
    vve g(n, ve());
    forn (i, m)
    {
        int u, v, w;
        scanf("%d%d%d", &u, &v, &w);
        --u, --v;
        assert(w>0);
        g[u].pb(TEdge(v, w, i));
        g[v].pb(TEdge(u, w, i));
        Q[mp(mp(u, v), w)]++;
        Q[mp(mp(v, u), w)]++;
    }
    vi d1 = dijkstra(g, 0);
    vi d2 = dijkstra(g, n - 1);
    //for (int x: d1) cerr << x << " "; cerr << endl;
    //for (int x: d2) cerr << x << " "; cerr << endl;
    vve ng(n, ve());
    forn (i, n)
        for (auto ed: g[i])
            if (d1[i] + i64(d2[ed.to]) + ed.w == d1[n - 1])
            {
                ng[i].pb(ed);
                ng[ed.to].pb(TEdge(i, ed.w, ed.num));
            }
    //forn (i, n) for (auto ed: ng[i]) cerr << i << " " << ed.to << endl;
    used.assign(n, false);
    forn (i, n)
        if (!used[i])
            dfs(ng, i);
    sort(all(ans));
    cout << ans.size() << "\n";
    for (int x: ans)
        cout << x + 1 << " ";
    cout << "\n";
    return 0;
}

